#!/bin/sh
# stahovatko czf4bfu souboru ze serveru podle zadanych zdroju
# pokousi se i o rekurzivni pristup a stahnuti jinak nedostupnych
# baliku

# sources je soubor s IP na jednom radku
SOURCES="${1:-$HOME/czf4bfu/zdroje.txt}"
# domeny ve kterych budu hledat czf4bfu host, jeho IP pouziju.
DOMENY="${2:-$HOME/czf4bfu/domeny.txt}"

# parametry pro wget
DSTDIR="/var/www/czf4bfu"

# parametry wgetu. 
# -N zapina overovani posledni modifikace, bohuzel dost serveru
# to nepodporuje nebo nema zapnute. Pripadne vypnout a nahradit 
# -nc, coz zajisti pri kazdem pokusu prepsani stareho
WGETPARAMS="-r -l 0 -N -np -nd -t 3 -A '.txt,.deu' -P $DSTDIR"

TMPFILE="/tmp/getall-czf-$RANDOM"
HOST=host
RSYNC=rsync
RSYNCPARAMS="-r "
SERVICE="rsync"

function getbyip()
{
IP=$1
	# prvni zkusim soubor primo z tou IP.
	# momentalne nutne u czela.czf
	$RSYNC $RSYNCPARAMS rsync://$IP/czf4bfu "$DSTDIR"
}

function getdnsip()
{
DOMAIN=$1
# Potom prihodim seznamy dle A recordu
# je nutne pridat czf4bfu v parametru
	$HOST $DOMAIN | sed \
		-e "/has address/ ! d" \
		-e "s/^.*has address \([[:digit:].]\+\)[[:space:]]*$/\1/"
}

function getsrvip()
{
# Ziskani pomoci SRV zaznamu
# trosku komplikace je, ze SRV vraci zaznam hostname, ne IP, takze jeste
# jednou resolve.
DOMAIN=$1
	host -t SRV _$SERVICE._tcp.czf4bfu.$DOMAIN | sed \
		-e "/SRV [[:digit:]]\+ [[:digit:]]\+ [[:digit:]]\+/ ! d" \
		-e "s/^.*SRV [[:digit:]]\+ [[:digit:]]\+ [[:digit:]]\+ \([[:alnum:].-]\+\)[[:space:]]*$/\1/" | \
		while read HOSTNAME; do
			getdnsip $HOSTNAME
		done
}

echo -n > "$TMPFILE"

# Jako prvni zkus najit zdroje v defaultni domene
# Pozor. Pokud nebude fungovat timestamp, je lepsi dat svuj lokalni
# DEU soubor jako read-only pro toho kdo spousti tento skript, jinak by
# mohl prepsat deu soubor pro tento stroj.
getdnsip czf4bfu >> $TMPFILE

# Napred zkusime hledani podle domen zadanych v souboru
[ -f "$DOMENY" ] && cat "$DOMENY" | while read DOMAIN; do
	echo "Domena: $DOMAIN"
	getsrvip $DOMAIN >> "$TMPFILE"
# Potom prihodim seznamy dle A recordu
# jenom SRV zatim
#	getdnsip czf4bfu.$DOMAIN >> "$TMPFILE"
done

# ted pridam do seznamu rucne zadane IP
# rsync budu delat z SRV jenom
#cat "$SOURCES" >> "$TMPFILE"

# seradim a vyhazu duplikaty
IPS=$(cat "$TMPFILE" | sort -u )

echo "Nalezene IP:"
echo "$IPS"

# a ted uz jenom stahnu
for IP in $IPS; do
	getbyip $IP
done

